﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RevisionAnalyser.Global;
using SharpSvn;
using System.Collections.ObjectModel;

namespace RevisionAnalyser.Projects.RecoderProject.Tasks
{
    public class TimelineTask : Task
    {
        private RecoderProject _project = (RecoderProject)CurrentProject.Instance.Project;

        public override void Run()
        {
            long lastRev = GetLastRevision();
            if (lastRev > 0)
            {
                //GetSvnLog(GetSvnLogArgs(lastRev));
                GetSvnLogArgs(lastRev);
            }
            TaskFinished();
        }

        private long GetLastRevision()
        {
            AddLog("Getting last revision...", Constants.COLOR_GREEN);
            SvnClient client = _project.GetSvnClient();
            SvnInfoEventArgs infoArgs;
            client.GetInfo(new SvnUriTarget(_project.SvnUrl), out infoArgs);
            AddLog(String.Format("Sucesfully retrieved the latest revision number ({0})", infoArgs.LastChangeRevision), Constants.COLOR_GREEN);
            return infoArgs.LastChangeRevision;
        }

        private SvnLogArgs GetSvnLogArgs(long lastRev)
        {
            SvnClient client = _project.GetSvnClient();
            AddLog(String.Format("Adding revisions for which we will retrieve the SVN log (maximum is {0})...", Constants.MAX_TIMELINE_REVISIONS), Constants.COLOR_GREEN);
            double stepSize = lastRev > Constants.MAX_TIMELINE_REVISIONS ? lastRev / Constants.MAX_TIMELINE_REVISIONS : 1;
            int[] added = new int[Constants.MAX_TIMELINE_REVISIONS];
            SvnLogArgs args = new SvnLogArgs();
            args.RetrieveAllProperties = false;
            args.RetrieveChangedPaths = false;
            args.RetrieveMergedRevisions = false;
            args.ThrowOnError = false;
            args.SvnError += new EventHandler<SvnErrorEventArgs>(args_SvnError);
            for (double d = 0; d < lastRev; d += stepSize)
            {
                int i = (int)d;
                if (!added.Contains(i))
                {
                    InsertTask(new TimelineSubTask(client, i));
                    //args.Ranges.Add(new SvnRevisionRange(i, i));
                }
            }
            return args;
        }

        private void GetSvnLog(SvnLogArgs args)
        {
            SvnClient client = _project.GetSvnClient();
            Collection<SvnLogEventArgs> logItems;
            client.SvnError += new EventHandler<SvnErrorEventArgs>(client_SvnError);
            client.Cancel += new EventHandler<SvnCancelEventArgs>(client_Cancel);
            client.GetLog(new Uri(_project.SvnUrl), args, out logItems);
            foreach (SvnLogEventArgs item in logItems)
            {
                AddLog(String.Format("Fetched SVN revision {0}", item.Revision), Constants.COLOR_GREEN);
                AddLog(String.Format("Revision: {0}", item.Revision), Constants.COLOR_GREEN);
                AddLog(String.Format("Author: {0}", item.Author), Constants.COLOR_GREEN);
                AddLog(String.Format("Time: {0}", item.Time.ToString()), Constants.COLOR_GREEN);
                AddLog(String.Format("Log Message: {0}", item.LogMessage), Constants.COLOR_GREEN);
            }
        }

        void client_Cancel(object sender, SvnCancelEventArgs e)
        {
            e.Cancel = false;
        }

        void client_SvnError(object sender, SvnErrorEventArgs e)
        {
            AddLog(e.Exception.Message, Constants.COLOR_RED);
            e.Cancel = false;
        }

        void args_SvnError(object sender, SvnErrorEventArgs e)
        {
            AddLog(e.Exception.Message, Constants.COLOR_RED);
        }
    }
}
